library(scales)

figureDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 6 - Salt marsh edge shell content/Figure components/'
csvDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 6 - Salt marsh edge shell content/CSV/'

setwd(csvDirectory)
d = read.csv('Bivalve survey all marshes with AHN inundation.csv')
d$NEAR_DIST[d$habitat == 'mudflat'] = -d$NEAR_DIST[d$habitat == 'mudflat'] 
massDensity.g_m2 = tapply(d$mass.g,d$sample.ID, sum,na.rm = T)
distanceToEdge.m = tapply(d$NEAR_DIST,d$sample.ID, unique)


r = 0.5
distanceR = round(distanceToEdge.m*r)/r

col = alpha(c('brown','green'),0.5)
y = tapply(massDensity.g_m2, distanceR, mean)
sd = tapply(massDensity.g_m2, distanceR, sd)
n = tapply(massDensity.g_m2, distanceR, length)
se = sd/sqrt(n)
x = sort(unique(distanceR))
habitat = x
habitat[] = 1
habitat[x >= 0] = 2
tiff(filename = 'Figure 6e.tif', width = 20, height = 12, units = 'cm', res = 300)
par(mar = c(5,5,4,4))
plot(y ~ x, log = '', pch = 21, ylim = c(0,500), xlim = c(-40,100), bg = col[as.numeric(habitat)], 
       ylab = expression('Bivalve mass density g m'^-2), xlab = 'Distance from marsh edge (m)', cex.lab = 1.2)
arrows(x0 = x, x1 = x, y0 = y + se, y1 = y - se, code = 3,length = 0.05, angle = 90)
fit = smooth.spline(y = y, x = x, df = 7)
xSeq = seq(min(x),max(x),length.out = 1000)
spline = predict(fit, xSeq)$y
spline[spline <= 0] = 0
lines(spline ~ xSeq, lwd = 2)  ## fitted spline
lines(y = c(0,500), x = c(0,0), lty = 2, col = grey(0.4), lwd = 2)
text('Salt marsh edge', y = 350, x = -5, srt = 90, col = grey(0.4))
text('Salt marsh', y = 30, x = 80, srt = 0, col = 1)
text('Mudflat', y = 30, x = -30, srt = 0, col = 1)
setwd(figureDirectory)
dev.off()

# --------------------------------


setwd(csvDirectory)
p1 = read.csv("Hellegat sediment data.csv")
p2 = read.csv("Coordinates, Weight, Malvern & Org. CN Sediment Samples Hellegat v2.csv")
d = merge(p1,p2, by = 'sample.ID')
d = d[!is.na(d$shell_dry_mass.g),]
shellMass.prop = d$shell_dry_mass.g/d$sediment_dry_mass.g
location = rep('saltmarsh', times = length(d$Distance.to.edge..m.))
location[d$Distance.to.edge..m. < 0] = 'mudflat'
location = factor(location)


colSeq = alpha(c('brown','green'),0.5)
plot(shellMass.prop ~ d$Distance.to.edge..m., pch = 21, bg = colSeq[location])
y = shellMass.prop
x = d$Distance.to.edge..m.
fit = smooth.spline(y = y, x = x, df = 6)
xSeq = seq(min(x),max(x),length.out = 1000)
spline = predict(fit, xSeq)$y
spline[spline <= 0] = 0
lines(spline ~ xSeq, lwd = 2)  ## fitted spline
lines(y = c(0,500), x = c(0,0), lty = 2, col = grey(0.4), lwd = 2)




tiff(filename = 'Figure 6d.tif', width = 20, height = 12, units = 'cm', res = 300)
par(mar = c(5,5,4,4))
plot(y ~ x, log = '', pch = 21, ylim = c(0,1), xlim = c(-40,100), bg = col[location], 
     ylab = 'Sediment shell content (prop.)',
     xlab = 'Distance from marsh edge (m)', cex.lab = 1.2)
fit = smooth.spline(y = y, x = x, df = 6)
xSeq = seq(min(x),max(x),length.out = 1000)
spline = predict(fit, xSeq)$y
spline[spline <= 0] = 0
lines(spline ~ xSeq, lwd = 2)  ## fitted spline
lines(y = c(0,1), x = c(0,0), lty = 2, col = grey(0.4), lwd = 2)
text('Salt marsh edge', y = 0.7, x = -5, srt = 90, col = grey(0.4))
text('Salt marsh', y = 0.1, x = 80, srt = 0, col = 1)
text('Mudflat', y = 0.2, x = -30, srt = 0, col = 1)
setwd(figureDirectory)
dev.off()
